<?
/*
 * uLike
 *
 * This script adds to comments system of "Like" as VKontakte. Only for uCoz.
 *
 * @package uLike
 * @author Maxim Seshuk <maxim.seshuk@gmail.com>
 * @author Vlad Aslamov <faforty@gmail.com>
 * @copyright Copyright (c) 2012
 * @version 1.5
 *
 */

class Ulike {
	public $no_photo;
	public $root = 1;
	public $uID = 1;
	public $domain;
	private $path;
	
	public function __construct($path = "./DB.dat"){
		$this->path = $path;
		$this->db = $this->database();
	}
	
	public function getLike(){
		$cid = $_GET['cid'];
		if(isset($_GET['folow'])==null || isset($_GET['folow'])==''){ //вывод кол-ва лайков
			$cid = explode(',',$cid);
			foreach($cid as $key => $idc){
				if(empty($idc)){
					unset($cid[$key]);
				}
				foreach ($this->db as $id => $users) {
							if ($idc == $id) {
								$ids_json[] = array(
									'id' => $id,
									'liked' => count($users),
									'my' => (in_array($this->uID, $users) ? 1 : 0)
								);
							}
						}
			}
			if(isset($ids_json)){
				return json_encode($ids_json);
			}else{
				throw new Exception('не верный запрос к базе данных или база данных пуста');
			}
		}elseif($_GET['folow']=='t'){ //вывод в tooltype
			return $this->getData($cid);
		}elseif($_GET['folow']=='m'){ //вывод в modal
			$page = $_GET['page'];
			if(empty($page)) $page = 0;
			return $this->getData($cid, 20, $page);
		}
	}
	
	
	public function postLike($id){ //сохранение лайков
		if (!is_numeric($this->uID) && !is_numeric($id)){
			throw new Exception('не верный ID пользователя или комментария');
		}
		if(in_array($id,array_keys($this->db))){
			$uid = array_search($this->uID,$this->db[$id]);
			if(is_numeric($uid)){
				unset($this->db[$id][$uid]);
				$this->database(1,$this->db);
				return 0;
			}else{
				$this->db[$id][] = $this->uID;
				$this->database(1,$this->db);
				return json_encode($this->getUData());
			}
		}else{
			$this->db[$id] = array($this->uID);
			$this->database(1,$this->db);
			return json_encode($this->getUData());
		}
	}
	
	public function getUData(){
		$user_xml = xmlrpc_decode(file_get_contents("http://".$this->domain."/api/index/8-" . $this->uID), "utf8");
		$photo    = $user_xml["USER_AVATAR"];
		if ($user_xml["USER_ID"] != null) {
			return array(
				'id' => (int) $this->uID,
				'photo' => ($photo != null ? $photo : $this->no_photo),
				'username' => $user_xml["USER_USERNAME"]
			);
        }
	}
	
	private function getData($cid,$k = 5, $page=0){
		if(in_array($cid,array_keys($this->db))){
				if($this->db[$cid]!=null){
					if($key = array_search( $this->uID, $this->db[$cid])){
						unset($this->db[$cid][$key]);
						array_unshift($this->db[$cid], $this->uID);
					}
				
					$perPage = $k;  
					$numPages = ceil(count($dataArray) / $perPage);   
					if(!$page || $page > $numPages) $page = 0;   
					$start = $page * $perPage;   
					$end = ($page * $perPage) + $perPage;   
				foreach($this->db[$cid] as $key => $users){
					$user_xml = xmlrpc_decode(file_get_contents("http://".$this->domain."/api/index/8-" . $users), "utf8");
					$photo    = $user_xml["USER_AVATAR"];
						if ($user_xml["USER_ID"] != null) {
							$ui[]      = array(
								'id' => (int) $users,
								'photo' => ($photo != null ? $photo : $this->no_photo),
								'username' => $user_xml["USER_USERNAME"]
							);
							$num_liked = count($this->db[$cid]);
						}
						if($key >= $start && $key > $end ) break;
				}
				return json_encode(array(
					'num_liked' => $num_liked,
					'likes' => $ui
				));
			}else{
				return 0;
			}
		}else{
			return 0;
		}
	}
	
	private function database($way = 0, $array = array()){
		if(file_exists($this->path)){
			$data = file_get_contents($this->path);
			if ($data){
				switch($way){
					case 0: //SELECT базы
						eval('$array=' . gzuncompress(stripslashes($data)) . ';');
						return unserialize($array);
					break;
					case 1: //сохранение базы
						$this->dbsave($this->dbgz($array));
						return true;
					break;
					case 2: //удаление базы
						$this->dbsave($this->dbgz(array(0=>array(1))));
						return true;
					break;
				}
			}else{
				$this->dbsave($this->dbgz(array(0=>array(1))));
				throw new Exception('База почему-то опустела, выполняем обновление базы...');
			}
		}else{
			throw new Exception('Не удалось соединиться с базой данных');
		}
	}
	private function dbgz($a){
		return addslashes(gzcompress(var_export(serialize($a), true), 9));
	}
	private function dbsave($s){
		return file_put_contents($this->path, $s);
	}
}
?>