/* =============================================================================
 *
 * Main javascript file
 *
 * ============================================================================= */

$(document).ready(function() {

    var cache = new Array();
    var isOpera = window.opera ? true : false;

    preloadImages('images/menu-item-over-bkg.png', 'images/social-links/facebook-over.png', 'images/social-links/delicious-over.png', 'images/social-links/digg-over.png',
        'images/social-links/flickr-over.png', 'images/social-links/rss-over.png', 'images/social-links/twitter-over.png', 'images/social-links/vimeo-over.png',
        'images/navigator-button-on.png', 'images/sidemenu-button-over.png', 'images/multitab-menuitem-over-bkg.png' );

    /* ------------------------------------------------------------
     * CUFON REPLACEMENT
     * ------------------------------------------------------------ */

    Cufon.replace('#logo-title, #logo-description', {
        //        textShadow: '0 1px 0px #2a508d'
        });

    /* ------------------------------------------------------------
     * MAIN MENU INITIALIZATION
     * ------------------------------------------------------------ */

    var animSpeed = 400,
    animType = 1;

    if ( window.PX_ANIMATION_SPEED ) {
        animSpeed = window.PX_ANIMATION_SPEED;
    }
    if ( window.PX_ANIMATION_TYPE ) {
        animType = window.PX_ANIMATION_TYPE;
    }

    $('#menu').pixelMenu({
        moreText: '',
        animationSpeed: animSpeed,
        animationType: animType
    });


    $("#s").click(function() {
        $("#s").val('');
    });

    $("#s").focusout(function() {
        if ($("#s").val() == '' ) {
            $("#s").val('enter search term ...');
        }
    });

    /* ------------------------------------------------------------
     * ROUNDABOUT SLIDER INIT
     * ------------------------------------------------------------ */

    $('#root .px-slider ul').roundabout({
        minOpacity: 1,
        minScale: 0.1
    });
    
    $('#root ul.gallery.carousel').jcarousel({
        scroll: 1,
        easing: 'easeOutCubic'
    });

    /* ------------------------------------------------------------
     * NIVO SLIDER INIT
     * ------------------------------------------------------------ */

    $('.px-slider.nivoSlider').nivoSlider({
        effect: 'random', // Specify sets like: 'fold,fade,sliceDown'
        slices: 15, // For slice animations
        boxCols: 10, // For box animations
        boxRows: 4, // For box animations
        animSpeed: 500, // Slide transition speed
        pauseTime: 60000, // How long each slide will show
        startSlide: 0, // Set starting Slide (0 index)
        directionNav: true, // Next & Prev navigation
        directionNavHide: false, // Only show on hover
        controlNav: true, // 1,2,3... navigation
        controlNavThumbs: false, // Use thumbnails for Control Nav
        controlNavThumbsFromRel: false, // Use image rel for thumbs
        controlNavThumbsSearch: '.jpg', // Replace this with...
        controlNavThumbsReplace: '_thumb.jpg', // ...this in thumb Image src
        keyboardNav: true, // Use left & right arrows
        pauseOnHover: true, // Stop animation while hovering
        manualAdvance: false, // Force manual transitions
        captionOpacity: 0.8, // Universal caption opacity
        prevText: 'Prev', // Prev directionNav text
        nextText: 'Next' // Next directionNav text
    });
    
    $('body .preload img').pixelImagePreloader();

    /* ------------------------------------------------------------
     * IMAGE HOVER EFFECT
     * ------------------------------------------------------------ */

    $('.recent-work ul li a, .widget.px-ad-widget ul li a').hover(
        function() {
            $(this).stop().css('backgroundColor', '#f1f1f1').animate({
                backgroundColor: $.Color('#dddddd')
            }, 400);
        },
        function() {
            $(this).stop().animate({
                backgroundColor: $.Color('#f1f1f1')
            }, 400);
        }
        );

    $('.recent-posts ul li a.post-thumb').hover(
        function() {
            $(this).stop().css('borderColor', '#e7e7e7').animate({
                borderColor: $.Color('#dddddd')
            }, 400);
        },
        function() {
            $(this).stop().animate({
                borderColor: $.Color('#e7e7e7')
            }, 400);
        }
        );
            
    /* ------------------------------------------------------------
     * PRETTYPHOTO INIT
     * ------------------------------------------------------------ */

    $("a[rel^='prettyPhoto']").prettyPhoto({
        overlay_gallery: false,
        social_tools: ''
    });


    /*
     * IMAGE ROLLOVER EFFECT */

    //    $('#root a.image-holder').append('<span class="image-zoom">');

    $('#root ul.flickr-widget li a, #root a.image-holder').hover(
        function() {
            $(this).find('img').stop().animate({
                opacity: 0.7
            }, 300);
        },
        function() {
            $(this).find('img').stop().animate({
                opacity: 1
            }, 300);
        }
        );

    $('#root a.image-holder').hover(
        function() {
            var elem = $(this).find('span.image-zoom');
            var h = elem.height();
            elem.css({
                top: - h - 12 + 'px',
                height: '100%',
                display: 'block'
            }).stop().animate({
                top: '6px'
            }, 500, 'easeOutCubic');
        },
        function() {
            var elem = $(this).find('span.image-zoom');
            var h = elem.height();
            elem.stop().animate({
                top: h + 12 + 'px',
                height: '100%'
            }, 500, 'easeInCubic', function() {
                $(this).css({
                    top: '0px',
                    display: 'none'
                });
            });
        }
        );
            
    /* ------------------------------------------------------------
     * MULTITAB INIT
     * ------------------------------------------------------------ */   
        
    $('#root .multitab-panel').pixelMultiTabs({
        navbarStyle: 'navbar'
    });    
    
    /* ------------------------------------------------------------
     * CONTACT FORM
     * ------------------------------------------------------------ */    
    
    $('#send-email-button').click(function(e) {
        e.preventDefault();
        $.post('email.php', {
            name: $('#con_name').val(),
            email: $('#con_email').val(),
            subject: $('#con_subject').val(),
            message: $('#con_message').val()
        }, function(data) {
            var response = '<div class="alert-box warning"><div class="icon"><p>'+ data +'</p></div></div>';
            $('#email-form div.alert-box').remove();
            $('#email-form').prepend(response);
            $('#email-form div.alert-box').hide().fadeIn(500);
        })
        return false;
    });
    
    /* ------------------------------------------------------------
     * SKIN SELECTOR
     * ------------------------------------------------------------ */
    
    var skinSelectorHTML = '<div id="skin-selector" class="off">'+
    '<a href="#" class="open-button"></a>'+
    '<div class="sidemenu">'+
    '<h3>Skin selector</h3>'+
    '<p>Feel free to change the global theme skin from this menu.</p><p>Also, check the other pages when changing the theme, some page features will reflect the new skin change.</p>'+
    '<ul>'+
    '<li><a href="#" class="default-skin" rel="default-theme">Default</a></li>'+
    '<li><a href="#" class="red-skin" rel="red-theme">Red</a></li>'+
    '<li><a href="#" class="green-skin" rel="green-theme">Green</a></li>'+
    '<li><a href="#" class="maroon-skin" rel="maroon-theme">Maroon</a></li>'+
    '<li><a href="#" class="olive-skin" rel="olive-theme">Olive</a></li>'+
    '<li><a href="#" class="light-green-skin" rel="light-green-theme">Light Green</a></li>'+
    '<li><a href="#" class="aqua-skin" rel="aqua-theme">Aqua</a></li>'+
    '<li><a href="#" class="purple-skin" rel="purple-theme">Purple</a></li>'+
    '<li><a href="#" class="yellow-skin" rel="yellow-theme">Yellow</a></li>'+
    '<li><a href="#" class="pink-skin" rel="pink-theme">Pink</a></li>'+
    '</ul></div></div>';
    
    $('body').append(skinSelectorHTML); // Comment this line to remove the skin selector side menu !
    
    $('#skin-selector a.open-button').click(function(e) {
        e.preventDefault();
        var base = $('#skin-selector');
        var isOn = base.attr('class');
        if ( isOn == 'on' ) {
            base.stop().animate({
                right: '-284px'
            }, 500, 'easeInCubic');
            base.removeAttr('class');
            base.addClass('off');
        } else {
            base.stop().animate({
                right: '-4px'
            }, 500, 'easeOutCubic');
            base.removeAttr('class');
            base.addClass('on');
        }
    })
    $('#skin-selector .sidemenu ul li a').click(function(e){
        e.preventDefault();
        var theme = $(this).attr('rel');
        var color = theme.replace('-theme', '');
        $('body').removeAttr('class');
        if ( theme != 'default-theme' ) {
            $('body').addClass(theme);
            $('a.custom-button').removeAttr('class').addClass('custom-button').addClass(color);
        } else {
            $('a.custom-button').removeAttr('class').addClass('custom-button').addClass('blue');
        }
    });    

    /* ------------------------------------------------------------
     * IMAGE PRELOADING
     * ------------------------------------------------------------ */   

    function preloadImages() {
        var img;
        var arg = arguments.length;
        for ( i = 0; i < arg ; i++ ) {
            img = document.createElement('img');
            img.src = arguments[i];
            cache.push(img);
        }
    }

});


/* =============================================================================
 *
 * 2011 @ PIXEL MULTITAB PLUGIN
 *
 * ============================================================================= */

(function($) {

    $.pixelMultiTabs = {
        defaults: {
            animationSpeed: 300,
            autoCreateNavbar: false,
            animationType: 2,
            navbarStyle: 'multi-tabs-navbar'
        }
    };

    $.fn.extend({
        pixelMultiTabs: function(config) {
            var config = $.extend({}, $.pixelMultiTabs.defaults, config);

            this.each(function(i) {

                var wrapper = $(this);

                var index = 0;
                if ( config.autoCreateNavbar ) {
                    var navBar = '<ul class="'+ config.navbarStyle +'">';
                    wrapper.find('li.tab').each(function() {
                        if ( index === 0 ) {
                            navBar += '<li class="selected"><div><a href="#">'+ $(this).attr('title') +'</a></div></li>';
                        } else {
                            navBar += '<li><div><a href="#">'+ $(this).attr('title') +'</a></div></li>';
                        }
                        index++;
                    });
                    navBar += '</ul>';
                    wrapper.prepend(navBar);
                }

                wrapper.find('ul.'+ config.navbarStyle +' li a').click(function(e) {
                    e.preventDefault();
                    if ( !$(this).parent().hasClass('selected')) {
                        wrapper.find('ul.'+ config.navbarStyle +' .selected').removeClass('selected');
                        $(this).parent().addClass('selected');
                        var selIndex = wrapper.find('ul.'+ config.navbarStyle +' li a').index($(this));
                        if ( config.animationType == '1' ) {
                            wrapper.find('li.tab.selected').slideUp(config.animationSpeed, function() {
                                wrapper.find('li.tab').removeClass('selected');
                                wrapper.find('li.tab').eq(selIndex).slideDown(config.animationSpeed).addClass('selected');
                            });
                        } else {
                            wrapper.find('li.tab.selected').fadeOut(config.animationSpeed, function(){
                                wrapper.find('li.tab').removeClass('selected');
                                wrapper.find('li.tab').eq(selIndex).fadeIn(config.animationSpeed).addClass('selected');
                            })
                        }
                    }
                })

                wrapper.find('ul.'+ config.navbarStyle +' li a:last').addClass('last');

                wrapper.css({
                    overflow: 'hidden'
                });
                wrapper.find('li.tab').css({
                    display: 'none'
                });
                wrapper.find('li.tab').eq(0).css({
                    display: 'block'
                }).addClass('selected');
            });
        }
    });

})(jQuery);


/* =============================================================================
 *
 * 2011 @ PIXEL TOOLTIP PLUGIN
 *
 * ============================================================================= */

(function($) {

    $.pixelTooltip = {
        defaults: {
            color: 'white',
            speed: 400,
            opacity: 1
        }
    }

    $.fn.extend({
        pixelTooltip: function(config) {
            var config = $.extend({}, $.pixelTooltip.defaults, config);
            config.selector = $(this);
            initialize(config);
        }
    });

    function initialize(config) {
        config.selector.each(function() {

            $(this).hover(
                function() {

                    var image = window.TEMPLATEPATH + '/images/custom_elements/tooltip-bkg.gif';

                    if ( config.color === 'black' ) {
                        image = window.TEMPLATEPATH + '/images/custom_elements/tooltip-black-bkg.gif';
                    }

                    var tooltipText = $(this).attr('title'),
                    tooltipBase = '<span class="tooltip-base"><strong class="'+ config.color +'">'+ tooltipText + '</strong><img src="'+ image +'" alt="" class="pointer" /></span>';

                    $(this).prepend(tooltipBase);
                    $(this).css({
                        position: 'relative'
                    });

                    $(this).find('.tooltip-base').css({
                        display: 'block',
                        opacity: 0,
                        top: -72 + 'px'
                    }).show().stop().animate({
                        top: -62 + 'px',
                        opacity: config.opacity
                    }, config.speed);
                },
                function() {
                    $(this).find('.tooltip-base').stop().animate({
                        top: -72 + 'px',
                        opacity: 0
                    }, config.speed - 100, function() {
                        $(this).remove();
                    });
                });
        });
    }

}(jQuery));


/* =============================================================================
 *
 * PIXELMENU Plugin Definition - 2011
 * Author: Pixelcloth
 * Version: 1.3
 *
 * ============================================================================= */

(function ($) {

    // config object

    $.fn.pixelMenu = function(params) {


        var defaults = {
            moreText: '',
            animationSpeed: 500,
            animationType: 1,
            delay: 0,
            menuWidth: 940
        };

        var config = $.extend({}, defaults, params);

        /*
             * Element filtering */

        var allMenuElems = $(this).find('li');
        var megaMenuElems = $(this).find('.pixel-mega-menu li');
        var subMenuElems = allMenuElems.not(megaMenuElems);
        var megaSubmenus = $(this).find('.pixel-mega-menu ul.sub-menu');

        /*
             * Adding some extra css styling to point out which menu item has children */

        $(this).find('ul.sub-menu').not(megaSubmenus).each(function() {

            var html = $(this).parent().find('a:first').html();
            if ( html == '' || html == null ) {
                $(this).parent().find('a:first').append('<span class="drop"></span>');
            } else {
                $(this).parent().find('a:first').append('<span class="drop"></span>');
            }
            $(this).css('display', 'none');
        });

        /*
             * Megamenu position correction */

        $(this).find('.pixel-mega-menu').each(function(index) {

            var pos = $(this).parent().position();
            var menuW = $(this).parent().parent().width();
            var width = $(this).outerWidth() + 20;
            var posLeft = 940 - menuW + pos.left;
            var diff = config.menuWidth - posLeft;

            if ( width > (diff)  ) {
                var newLeft = width - diff;

                $(this).css({
                    left: - newLeft
                })
            }
        });

        /*
             * Hover action bind */

        subMenuElems.hover(

            function() {

                var selElem = $(this).find('ul.sub-menu:first');

                switch ( config.animationType ) {
                    case 1 :
                        selElem.css({
                            overflow: 'hidden',
                            height: 'auto',
                            display: 'none',
                            filter: ''
                        })
                        /*
                        .stop().animate({
                            top: '50px'
                        }, config.animationSpeed);*/

                        .stop().slideDown(config.animationSpeed, function() {
                            $(this).css('overflow', 'visible')
                        });
                        break;
                    case 2 :
                        selElem.css({
                            overflow: 'hidden',
                            height: 'auto',
                            display: 'none',
                            opacity: 1,
                            filter: ''
                        }).stop().fadeIn(config.animationSpeed, function() {
                            $(this).css('overflow', 'visible')
                        });
                        break;
                    default:
                        break;
                }
            },
            function() {
                $(this).find('ul.sub-menu').removeAttr('style');
            }
            );
    }
})(jQuery);



/* =============================================================================
 *
 * PIXEL IMAGE PRELOADER Plugin Definition - 2011
 * Author: Pixelcloth
 * Version: 1.0
 *
 * ============================================================================= */

(function($) {

    $.pixelImagePreloader = {
        defaults: {
            animSpeed: 500,
            loops: 20,
            delay: 100
        }
    };

    $.fn.extend({

        pixelImagePreloader: function(config) {
            
            var config = $.extend($.pixelImagePreloader.defaults, config);
            var images = $(this);
            var tmpImages = images;
            var noItems = images.length;
            var loadedItems = 0;
            var incr = 0;

            var methods = {

                init: function() {
                    images.each(function() {
                        $(this).parent().prepend('<div class="preloading"></div>');
                        $(this).parent().find('span.image-zoom').css('display', 'none');
                    })
                    methods.checkImages();
                },

                checkImages: function() {

                    incr++;

                    tmpImages.each(function() {
                        if ( this.complete == true ) {
                            loadedItems++;
                            tmpImages = tmpImages.not(this);
                        }
                    });

                    if ( loadedItems == noItems ) {
                        setTimeout(methods.displayImages, 500);
                    } else if ( incr <= config.loops ) {
                        setTimeout(methods.checkImages, 500);
                    }
                },

                displayImages: function() {
                                       
                    images.each(function(i) {
                        
                        //                        var delay = 100;
                        
                        var currentImage = $(this);
                        
                        $(this).parent().find('.preloading').delay(i*config.delay).fadeOut(500, function() {
                            $(this).remove();
                        });
                        
                        currentImage.css({
                            visibility: 'visible'                            
                        }).delay(i*config.delay).fadeIn(500, function() {
                            //                            $(this).parent().find('span.image-zoom').css('display', 'block');
                            });                        
                    });
                }
            }

            methods.init();

        }
    });
    
    
})(jQuery);